/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.resource;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_2960;
import net.minecraft.class_3270;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.chisel.ctm.client.resource.CTMMetadataSection;
import team.chisel.ctm.client.resource.CTMMetadataSectionV1;

public class CTMMetadataReader
implements class_3270<CTMMetadataSection> {
    public static final String SECTION_KEY = "ctm";
    public static final CTMMetadataReader INSTANCE = new CTMMetadataReader();
    private static final Map<Integer, CTMMetadataFactory> FACTORIES = new ImmutableMap.Builder().put((Object)1, CTMMetadataSectionV1::fromJson).build();

    @Nullable
    public CTMMetadataSection fromJson(@Nullable JsonObject jsonObject) throws JsonParseException {
        if (jsonObject != null) {
            if (jsonObject.has("ctm_version")) {
                CTMMetadataFactory factory = FACTORIES.get(jsonObject.get("ctm_version").getAsInt());
                if (factory == null) {
                    throw new JsonParseException("Invalid \"ctm_version\"");
                }
                return factory.getCTMMetadata(jsonObject, this::makeIdentifier);
            }
            throw new JsonParseException("Found ctm section without \"ctm_version\"");
        }
        return null;
    }

    @NotNull
    public String method_14420() {
        return SECTION_KEY;
    }

    public class_2960 makeIdentifier(String string) {
        return new class_2960(string);
    }

    public static interface CTMMetadataFactory {
        public CTMMetadataSection getCTMMetadata(JsonObject var1, Function<String, class_2960> var2);
    }
}

